import { Component, OnInit } from '@angular/core';
import { FormControl, Validators, FormBuilder } from '@angular/forms';
import { Router } from '@angular/router';
import { IAppState } from '../store/reducers/video.reducer';
import { Store } from '@ngrx/store';
import { FindTranscriptById } from '../store/actions/video.actions';

@Component({
  selector: 'app-find-video-id',
  templateUrl: './find-video-id.component.html',
  styleUrls: ['./find-video-id.component.scss']
})
export class FindVideoIdComponent implements OnInit {
  videoIdForm = this.fb.group({
    videoid: ['', Validators.required]
  });

  constructor(
    private fb: FormBuilder,
    private router: Router,
    private store: Store<IAppState>
  ) { }

  ngOnInit() {
  }

  onSubmitId() {
    if (this.videoIdForm.valid) {
      this.router.navigateByUrl('/?id=' + this.videoIdForm.value.videoid);
    }
  }

}
