import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { HttpClientModule } from '@angular/common/http';
import { MatToolbarModule, MatSnackBarModule, MatInputModule, MatButtonModule, MatProgressSpinnerModule } from '@angular/material';
import { MatIconModule } from '@angular/material/icon';
import { StoreDevtoolsModule } from '@ngrx/store-devtools';
import { StoreModule } from '@ngrx/store';
import { EffectsModule } from '@ngrx/effects';

import { AppComponent } from './app.component';
import { VideoEffects } from './store/effects/video.effects';
import { VideoService } from './store/services/video.services';
import { VideoDetailsComponent } from './video-details/video-details.component';
import { AppRoutingModule } from './app.routing.module';
import { videoReducer } from './store/reducers/video.reducer';
import { EventService } from './store/services/event.service';
import { OrderByPipe } from './store/pipes/order.pipe';
import { FindVideoIdComponent } from './find-video-id/find-video-id.component';

@NgModule({
  declarations: [
    AppComponent,
    VideoDetailsComponent,
    FindVideoIdComponent,
    OrderByPipe
  ],
  imports: [
    BrowserModule,
    BrowserAnimationsModule,
    HttpClientModule,
    FormsModule,
    ReactiveFormsModule,
    AppRoutingModule,
    MatButtonModule,
    MatInputModule,
    MatToolbarModule,
    MatSnackBarModule,
    MatProgressSpinnerModule,
    MatIconModule,
    StoreModule.forRoot({
      videoState: videoReducer
    }),
    EffectsModule.forRoot([ VideoEffects ]),
    StoreDevtoolsModule.instrument()
  ],
  providers: [ VideoService, EventService ],
  bootstrap: [AppComponent]
})
export class AppModule { }
