import { Injectable } from "@angular/core";
import { Observable } from "rxjs";
import { HttpClient } from "@angular/common/http";
import { ITranscript } from "../models/video.models";

@Injectable()
export class VideoService {
    readonly transcriptUrl = "https://static.chorus.ai/api";

  constructor(private httpClient: HttpClient) { }

  loadTranscriptById(id: number): Observable<any> {
    return this.httpClient.get(this.transcriptUrl + '/' + id + ".json");
  }

}
