import { Injectable } from "@angular/core";
import { Actions, Effect, ofType } from "@ngrx/effects";
import { map, mergeMap, catchError } from "rxjs/operators";
import { VideoActionsTypes } from "../actions/video.actions";
import { of } from "rxjs";
import { MatSnackBar } from "@angular/material";
import { Router } from "@angular/router";
import { VideoService } from "../services/video.services";

@Injectable()
export class VideoEffects {

    @Effect()
    loadTranscriptById$ = this.actions$
        .pipe(
            ofType(VideoActionsTypes.LOAD_TRANSCRIPT_BY_ID),
            map((action: any) => action.payload),
            mergeMap(id => this.videoService.loadTranscriptById(id)
                .pipe(
                    map(ticket => ({
                        type: VideoActionsTypes.LOAD_TRANSCRIPT_BY_ID_SUCCESS,
                        payload: ticket
                    })),
                    catchError(error => {
                        this.router.navigate(["Video"]);
                        this.snackBar.open(
                            "ERROR: There were some errors",
                            "Error",
                            {
                                duration: 5000
                            }
                        );
                        return of({
                            type: VideoActionsTypes.LOAD_TRANSCRIPT_BY_ID_ERROR,
                            payload: error
                        });
                    })
                ))
        );

    constructor(
        private videoService: VideoService,
        private actions$: Actions,
        private router: Router,
        private snackBar: MatSnackBar
    ) { }
}