import { Injectable, Renderer2 } from '@angular/core';

@Injectable()
export class EventService {

    constructor() { }

    addEvents(renderer: Renderer2, events): void {
        for (const event of events) {
            event.dispose = renderer.listen(event.element, event.name, newEvent => event.callback(newEvent));
        }
    }

    removeEvents(events): void {
        for (const event of events) {
            if (event.dispose) {
                event.dispose();
            }
        }
    }

}
