import { VideoActionsTypes } from "../actions/video.actions";

export interface IVideoState {
    transcript: any,
  videoId: string,
  loading: boolean;
  error: boolean;
}

export const initialState: IVideoState = {
  transcript: [],
  videoId: null,
  loading: false,
  error: false
};

export function videoReducer(state: IVideoState = initialState, action: any): IVideoState {
  switch(action.type) {

    case VideoActionsTypes.LOAD_TRANSCRIPT_BY_ID: {
      return {
        ...state,
        loading: true
      };
    }

    case VideoActionsTypes.LOAD_TRANSCRIPT_BY_ID_SUCCESS: {
      return {
        ...state,
        loading: false,
        error: false
      };
    }

    case VideoActionsTypes.LOAD_TRANSCRIPT_BY_ID_ERROR: {
      return {
        ...state,
        loading: false,
        error: true
      };
    }

  }
    return state;

}
