import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';
import { BrowserAnimationsModule } from "@angular/platform-browser/animations";
import { MatToolbarModule, MatSnackBarModule } from '@angular/material';
import { StoreDevtoolsModule } from "@ngrx/store-devtools";
import { StoreModule } from '@ngrx/store';
import { EffectsModule } from '@ngrx/effects';

import { AppComponent } from './app.component';
import { VideoEffects } from './store/effects/video.effects';
import { VideoService } from './store/services/video.services';
import { VideoDetailsComponent } from './video-details/video-details.component';
import { AppRoutingModule } from './app.routing.module';
import { videoReducer } from './store/reducers/video.reducer';
import { HttpClientModule } from '@angular/common/http';

@NgModule({
  declarations: [
    AppComponent,
    VideoDetailsComponent
  ],
  imports: [
    BrowserModule,
    BrowserAnimationsModule,
    HttpClientModule,
    AppRoutingModule,
    MatToolbarModule,
    MatSnackBarModule,
    StoreModule.forRoot({
      video: videoReducer
    }),
    EffectsModule.forRoot([ VideoEffects ]),
    StoreDevtoolsModule.instrument()
  ],
  providers: [ VideoService ],
  bootstrap: [AppComponent]
})
export class AppModule { }
